// Defining Your Own Print Document:
// For a complex print job, or a print logic that you wish to reuse across
// multiple forms, you can derive a new class from PrintDocument and encapsulate
// your printing logic in that class. In this case, you handle the PrintPage
// event by overriding the OnPrintPage method, rather than using an event handler.

program PrintForm;

{%DelphiDotNetAssemblyCompiler '$(SystemRoot)\microsoft.net\framework\v1.1.4322\System.Drawing.dll'}
{%DelphiDotNetAssemblyCompiler '$(SystemRoot)\microsoft.net\framework\v1.1.4322\System.Windows.Forms.dll'}

uses
  System.Windows.Forms,
  System.Drawing,
  System.Drawing.Printing,
  System.io,
  PrintDoc in 'PrintDoc.pas',
  Controls in 'Controls.pas';

type
  { Application main form }
  TMainForm = class(Form)
  private
    procedure InitComponents;
    procedure Button1Click(Sender: TObject; e: EventArgs);
  published
    Button1: Button;
  public
    constructor Create(Owner: TObject);
  end;

{ TMainForm }

constructor TMainForm.Create(Owner: TObject);
begin
  inherited Create;
  InitComponents;
end;

procedure TMainForm.InitComponents;
begin
  SuspendLayout;

  Text:= 'Defining Your Own Print Document';
  AutoScaleBaseSize:= System.Drawing.Size.Create(5, 13);
  ClientSize:= System.Drawing.Size.Create(500, 380);

  Button1:= Button.Create;
  Button1.Top:= 5;
  Button1.Left:= 5;
  Button1.Width:= 100;
  Button1.ImageAlign:= ContentAlignment.MiddleLeft;
  Button1.FlatStyle:= FlatStyle.Flat;
  Button1.TabIndex:= 0;
  Button1.Text:='Print';
  Button1.Add_Click(Button1Click);
  Controls.Add(Button1);

  ResumeLayout(False);
end;

procedure TMainForm.Button1Click(Sender: TObject; e: EventArgs);
var
  pd: TTextFilePrintDocument;
  aStream: StreamReader;
begin
  try
    aStream:= StreamReader.Create('PrintMe.txt');
    try
      pd:= TTextFilePrintDocument.Create(aStream); //Assumes the default printer
      pd.Print;
      MessageBox.Show('Document printed!');
    finally
      aStream.Close;
    end;
  except
    on E: System.Exception do
      MessageBox.Show('An error occurred printing the file - ' + E.Message);
  end;
end;

{$R *.res}

begin
  Application.Run(TMainForm.Create(nil));
end.
